@echo off
REM ---------------------------------------------------------------------------
REM
REM  Copyright (C) Intel Corporation, 2003 - 2006.
REM
REM  File:      management_cosole_req.bat
REM
REM  Contents:  batch file which creates a request for a subordinate CA.
REM
REM ----------------------------------------------------------------------------

REM ######################################################################
REM ###                                                                ###
REM ### This batch may be called by the Configuration Server program   ###
REM ### in order to generate a Subordinate CA certificate request      ###
REM ### you may customize this script and modify the defaults          ###
REM ### at your own risk.                                              ###
REM ###                                                                ###
REM ######################################################################

setlocal

set PATH= %PATH%;../openSSL
set CATOP=.\local_client
set SSLEAY_CONFIG=-config ./local_client.cfg
set CAKEY=.\cakey.pem
set CACERT=.\cacert.pem
set DAYS=-days 365

rmdir /q /s %CATOP%

mkdir %CATOP%
mkdir %CATOP%\certs 
mkdir %CATOP%\crl 
mkdir %CATOP%\newcerts
mkdir %CATOP%\private
echo 01 > %CATOP%\serial
copy nul %CATOP%\index.txt

openssl req %SSLEAY_CONFIG% -new -x509 -keyout %CATOP%\private\%CAKEY% -out %CATOP%\%CACERT% %DAYS%


REM ### Delete self-signed subCA Certificate ###

del /q %CATOP%\%CACERT% %CATOP%\private\%CAKEY%


REM ### Generate subCA Certificate request & key ###

openssl req %SSLEAY_CONFIG% -new -keyout %CATOP%\private\local_client_key.pem -out %CATOP%\certreq.pem %DAYS%

endlocal

IF NOT %CALLER_WAITS_ON_EXIT%=="" EXIT




